(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 16.8.01 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * type and utility functions for free unique type variables
 *
 * $Id: type_variable.mli,v 1.5 2002-05-03 15:01:20 tews Exp $
 *
 *)

(* 
 * the type of uniqeness, 
 * at the moment max_int - min_int elements are available, 
 * then an assertion is thrown
 *)

type t 


(* create a new uniqe element *)

val fresh : unit -> t


(* compare to elements *)

val eq : t -> t -> bool


val string_of_tv: t -> string


val number_of_free_variables : unit -> int


(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

