(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 15.1.99 by Hendrik
 *
 * Time-stamp: <Monday 11 March 02 11:39:35 tews@ithif51>
 *
 * Utility functions
 *
 * $Id: util.ml,v 1.4 2002/05/03 15:01:20 tews Exp $
 *
 *)



(*******************************************************************
 *******************************************************************
 *
 * Exceptions
 *)


(*******************************************************************
 *
 * for internal invariants: if a match has a case which should never 
 * occur and if it is not possible to define the match using less 
 * Variants I suggest to insert a line
 *   begin assert(false) end
 * 
 *)
exception Internal_error


(*******************************************************************
 *
 * Support for growing implementation
 *)
exception To_be_implemented of string


(* exception thrown by find_member and find_local_member,
 * if a member is not found
 *)
exception Member_not_found

(*******************************************************************
 *******************************************************************
 *
 * List utility functions
 *)

let upto i = 
  let rec doit = 
    function
      | 0 -> []
      | i -> (i - 1) :: (doit (i - 1)) 
  in
    List.rev (doit i)

let rec last = function
  | [] ->
      assert false
  | [x] -> x
  | _ :: xs -> last xs;;


let rec but_last = function
  | [] ->
      assert false
  | [x] -> []
  | x :: xs -> x :: but_last xs;;

					(* member with explicit equality *)
let rec member eq x l =
  match l with
    | [] -> false
    | y :: k -> (if (eq x y) then true else (member eq x k))

					(* assoc with explicit equality *)
let rec assoc eq x = function
  | [] -> raise Not_found
  | (a,b)::l -> if eq x a then b else assoc eq x l


let remove_duplicates eq al =
  let rec doit res = function
    | a :: al -> (if member eq a res then doit res al
                  else doit (a :: res) al)
    | [] -> res
  in
    doit [] al

let option_filter ol = 
  List.map (function 
	      | Some x -> x
	      | None -> assert(false))
    (List.filter (function
		    | Some _ -> true
		    | None -> false)
       ol)


let rec take l = function
  | 0 -> []
  | n -> (List.hd l) :: (take (List.tl l) (n-1))

let rec tail l = function
  | 0 -> l
  | n -> tail (List.tl l) (n-1)


let rec map3 f l1 l2 l3 =
  match (l1, l2, l3) with
    ([], [], []) -> []
  | (a1::l1, a2::l2, a3::l3) -> 
      let r = f a1 a2 a3 in r :: map3 f l1 l2 l3
  | _ -> invalid_arg "Util.map3"


let rec combine3 l1 l2 l3 =
  match (l1, l2, l3) with
    ([], [], []) -> []
  | (a1::l1, a2::l2, a3::l3) -> (a1, a2, a3) :: combine3 l1 l2 l3
  | (_, _, _) -> invalid_arg "Util.combine3"


(***********************************************************************
 ***********************************************************************
 * 
 * Function composition section
 *)


let (@@) = fun f g x -> g ( f x );;


(*******************************************************************
 *******************************************************************
 *
 * Option utilities
 *)


let remove_option = function
  | None ->
      assert false
  | Some o -> o;;


(*******************************************************************
 *******************************************************************
 *
 * file utilities
 *)

(* make a backup for file *)
let make_backup file = 
  let backup_name = file ^ "~" in
    try Sys.rename file backup_name
    with Sys_error _ -> ()
	

(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)
