(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 26.2.99 by Bart
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * Utility functions for all pretty printers
 *
 * $Id: pretty_util.ml,v 1.4 2002/05/03 15:01:18 tews Exp $
 *
 *)

open Formatter;;

(* 
   * Auxiliary function for processing lists in pretty printing
   * input:
   *   pp : 'a -> unit
   *   r_del  : string
   *   l_del  : string
   *   base   : string
   *   op     : string
   * result:
   *   ('a list) -> unit
*)

let pp_list pp r_del l_del base op = function
    [] -> 
      print_string base
  | t :: tl ->
      begin
	open_box 0;
	print_string r_del; 
	pp t; 
	print_string l_del;
	List.iter
	  (fun t' ->
	     begin
	       print_space();
	       print_string op; 
	       print_space();
	       print_string r_del; 
	       pp t'; 
	       print_string l_del;
	     end) tl;
	close_box()
      end;;


(* splits a string on newlines into lists of strings without newlines 
   * s : string
   * result : string list
*)
let split_on_newline s =
  let res = ref []  in
  let act = ref 0 in
    begin
      for i = 0 to (String.length s) - 1
      do
        if 
	  s.[i] = '\n' 
	then
          begin
            res := !res @ [(String.sub s !act (i - !act))] ;
            act := i+1
          end
      done;
      res := !res @ [(String.sub s !act ((String.length s) - !act))];
      !res
    end




(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

