(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 17.November 1999 by Jan
 *
 * Time-stamp: <Sunday 10 March 02 11:51:58 tews@ithif56.inf.tu-dresden.de>
 *
 * convert CCSL specifics into HOL for the pretty printer
 *
 * $Id: pre_printing.mli,v 1.6 2002/05/03 15:01:13 tews Exp $
 *
 *)

open Classtypes;;
open Types_util;;

val ccsl_pre_pretty_list: ('a -> 'a) -> 'a list -> 'a list

(* the first argument is the current class or adt,
 * the second argument delivers a algebra (a coalgebra respectively) 
 * for a given typ, the second for a given member. The first argument 
 * is applied to the type arguments of Box, Diamond, Obseq.
 *  The argument is either of form
 *   Class( ...), Adt( ... ), or Self
 * The second argument is unsed for Member and MethodSelection.
 * Then the pre_prettyprinting can do its main 
 * task -- to silently insert coalgebras and algebras whereever needed. 
 * The functional dependence is needed for components with final or 
 * loose semantics and to distinguish the current class.
 * 
 * !!! We --the world-- and especially this code assumes that this 
 * function deliver name_of_coalgebra for the current class !!!
 *)

val ccsl_pre_pretty_expression: 
  ccsl_iface_type ->
    (ccsl_member_type -> ccsl_expressions option) ->
      (ccsl_output_types -> ccsl_expressions) ->
	ccsl_expressions ->
	  ccsl_expressions

val ccsl_pre_pretty_formula:
  ccsl_iface_type ->
    (ccsl_member_type -> ccsl_expressions option) ->
      (ccsl_output_types -> ccsl_expressions) ->
	ccsl_formulas ->
	  ccsl_formulas


(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

