(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 26.1.99 by Hendrik
 *
 * Time-stamp: <Monday 24 June 02 17:44:56 tews@ithif51>
 *
 * printing error messages
 *
 * $Id: error.ml,v 1.6 2002/07/03 12:01:17 tews Exp $
 *
 *)


open Global;;
open Top_variant_types;;


    (* print a status message
     * : string -> unit
     *)
let print_message message =
  prerr_string ("Message: " ^ message ^ "\n");
  flush stderr;;


    (* print a warning message
     * : string -> unit
     *)
let print_warning message =
  prerr_string ("Warning: " ^ message ^ "\n");
  prerr_string ("Continuing\n");
  flush stderr;;


    (* print an error message 
     * : string -> unit
     *
     * Note : to enable error recovery, this function does not exit
     * call exit (<some error code>) if required
     *)
let print_error message =
  prerr_string ("Error: " ^ message ^ "\n");
  prerr_string ("Continuing\n");
  flush stderr;;


let print_verbose message =
  if debug_level _VERBOSE
  then begin
    print_string (message ^ "\n");
    flush stdout;
  end;;

let string_of_loc loc = 
  "\"" ^ loc.file_name ^ "\"" ^ ", line " ^
  (string_of_int loc.start_line) ^ " (char " ^
  (string_of_int loc.start_char) ^ 
  (if loc.start_line = loc.end_line 
   then 
     if loc.start_char = loc.end_char
     then
       ")"
     else 
       "-" ^ (string_of_int loc.end_char) ^ ")" 
   else
     ") - line " ^
     (string_of_int loc.end_line) ^ " (char " ^
     (string_of_int loc.end_char) ^ ")" 
  )
;;

    (* val error_message : token -> string -> unit 
     *
     * prints a line of the form 
     * test.beh: line 14: message
     *)
let warning_message loc s =
  prerr_string ("Warning in " );
  prerr_string (string_of_loc loc);
  prerr_string ":\n";
  prerr_string (s ^ "\n\n");
  flush stderr;; 

let error_message loc s =
  prerr_string ("Error in " );
  prerr_string (string_of_loc loc);
  prerr_string ":\n";
  prerr_string (s ^ "\n\n");
  flush stderr;; 

  
let pedantic_error loc s =
  error_message loc ("Pedantic error: " ^ s);
  raise PedanticViolation


(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)
