(* 
 * Formalized Cut Elimination in Coalgebraic Logics
 * 
 * Copyright (C) 2013 - 2013 Hendrik Tews
 * 
 * This file is part of my formalization of "Cut Elimination in 
 * Coalgebraic Logics" by Dirk Pattinson and Lutz Schroeder.
 * 
 * The formalization is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * The formalization is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the formalization in the file COPYING. 
 * If not, see <http://www.gnu.org/licenses/>.
 * 
 * $Id: list_multiset.v,v 1.14 2013/04/10 11:17:15 tews Exp $
 *)

(** ** Lists as multisets 

      The subset relation on multi-sets is essential. I simply use
      [list_reorder] to define it.
*)

Require Export reorder.

Section Multisets.

  Variable A : Type.

  Variable aeq : eq_type A.


  Definition multi_subset(l1 l2 : list A) : Prop :=
    exists(l3 : list A), list_reorder (l1 ++ l3) l2.

  Lemma multi_subset_trans : forall(l1 l2 l3 : list A),
    multi_subset l1 l2 ->
    multi_subset l2 l3 ->
      multi_subset l1 l3.
  Proof.
    intros l1 l2 l3 H H0.
    destruct H as [l1'].
    destruct H0 as [l2'].
    exists (l1' ++ l2').
    rewrite app_assoc.
    eapply list_reorder_trans.
    eapply list_reorder_append_right.
      eexact H.
    trivial.
  Qed.

  Lemma multi_subset_antisymm : forall(l1 l2 : list A),
    multi_subset l1 l2 ->
    multi_subset l2 l1 ->
      list_reorder l1 l2.
  Proof.
    intros l1 l2 H H0.
    destruct H as [l2wol1].
    destruct H0 as [l1wol2].
    assert (length l2wol1 = 0).
      apply list_reorder_length in H.
      apply list_reorder_length in H0.
      rewrite app_length in *.
      omega.
    destruct l2wol1.
      rewrite app_nil_r in *.
      trivial.
    discriminate.
  Qed.

End Multisets.

Implicit Arguments multi_subset [A].
